<?php
/* --------------------------------------------------------------
   AfterbuyOrderExtender.inc.php 2018-05-25
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2018 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
   --------------------------------------------------------------
*/

class AfterbuyOrderExtender extends AfterbuyOrderExtender_parent
{
    public $v_output_buffer;
    
    
    /**
     * Proceed with the execution of the extender.
     */
    public function proceed()
    {
        parent::proceed();
        
        if ((bool)gm_get_conf('MODULE_CENTER_GAMBIOAFTERBUY_INSTALLED') === true) {
            $db           = StaticGXCoreLoader::getDatabaseQueryBuilder();
            $afterbuyData = $db->select('afterbuy_success, afterbuy_id')
                ->where('orders_id', (int)$_GET['oID'])
                ->get('orders')
                ->row_array();
            
            $contentView = MainFactory::create('ContentView');
            $contentView->set_template_dir(DIR_FS_CATALOG . 'GXModules/Gambio/Afterbuy/Admin/Templates/');
            $contentView->set_content_template('order_info.html');
            $contentView->set_flat_assigns(true);
            $contentView->set_caching_enabled(false);
            $contentView->set_content_data('afterbuy_success', $afterbuyData['afterbuy_success']);
            $contentView->set_content_data('afterbuy_id', $afterbuyData['afterbuy_id']);
            
            $this->v_output_buffer                     = is_array($this->v_output_buffer) ? $this->v_output_buffer : [];
            $this->v_output_buffer['below_order_info'] = $contentView->get_html();
            
            $txt                                               = MainFactory::create('LanguageTextManager',
                                                                                     'afterbuy',
                                                                                     $_SESSION['languages_id']);
            $this->v_output_buffer['below_order_info_heading'] = $txt->get_text('order_info_heading');
            $this->addContent();
        }
    }
}
